﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Xml.Serialization;

namespace KursBeispiele
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        //Hier wird der neue Eintrag geladen
        private void button1_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                FileStream fs = null;

                //Hier wird der XML-Serializier instanziiert
                XmlSerializer xmls = new XmlSerializer(typeof(BeispielKlasse));

                //Da dieser Prozess eine unbekannte (Dateisystem) beinhaltet, sollten wir
                //einen try-catch (oder try-finally) Block verwenden
                try
                {
                    fs = new FileStream(openFileDialog1.FileName, FileMode.Open, FileAccess.Read);
                    BeispielKlasse bk = xmls.Deserialize(fs) as BeispielKlasse;

                    textBox1.Text = bk.Titel;
                    textBox2.Text = bk.Nachricht;
                    numericUpDown1.Value = bk.Wert;
                }
                catch (Exception ex)
                {
                    //Hier machen wir try-catch - wir wollen informiert werden, falls was schief geht
                    MessageBox.Show(ex.Message, "Fehler", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
                finally
                {
                    if (fs != null)
                        fs.Close();
                }
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                //Wir erstellen eine Klasse und füllen diese mit Werten
                BeispielKlasse bk = new BeispielKlasse();
                bk.Wert = (int)numericUpDown1.Value;
                bk.Titel = textBox1.Text;
                bk.Nachricht = textBox2.Text;

                FileStream fs = null;

                //Hier wird der XML-Serializier instanziiert
                XmlSerializer xmls = new XmlSerializer(typeof(BeispielKlasse));

                //Da dieser Prozess eine unbekannte (Dateisystem) beinhaltet, sollten wir
                //einen try-catch (oder try-finally) Block verwenden
                try
                {
                    //nun stehen die Flags auf Create und Write (!)
                    fs = new FileStream(saveFileDialog1.FileName, FileMode.Create, FileAccess.Write);

                    //Hier wird serialisiert
                    xmls.Serialize(fs, bk);
                }
                catch (Exception ex)
                {
                    //Hier machen wir try-catch - wir wollen informiert werden, falls was schief geht
                    MessageBox.Show(ex.Message, "Fehler", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
                finally
                {
                    if (fs != null)
                        fs.Close();
                }
            }
        }
    }
}
